using UnityEngine;
using TMPro;

// This class is holds the basic information of a downloaded map prefab
public class Object_MapDisplayCloud : MonoBehaviour
{

    private MapData_Cloud mapData;
    private Manager_MapDataCloud mapHolder;
    [SerializeField] private TextMeshProUGUI mapNameText;
    [SerializeField] private TextMeshProUGUI downloadText;
    [SerializeField] private TextMeshProUGUI likeText;
    [SerializeField] private TextMeshProUGUI avgRatingText;

    public void Awake()
    {
        GameObject managers = GameObject.FindWithTag("Manager_Cloud");
        mapHolder = managers.GetComponent<Manager_MapDataCloud>();
    }

    // Using MapHolder to show the map edit menu
    public void OpenMapInteractionMenu()
    {
        mapHolder.PopoulateInteractionMenu(mapData);
    }

    // Set the map data
    public void SetMapData(MapData_Cloud mapData)
    {
        this.mapData = mapData;
        mapNameText.text = $"{mapData.mapName}\nBy {mapData.mapAuthor}";
        
        float avgRating = mapData.rates > 0 ? (float)mapData.totalRating / mapData.rates : 0f;
        if (avgRating == 0f)
        {
            avgRatingText.text = "No Ratings Yet";
        }
        else
        {
            avgRatingText.text = $"Avg. Rating:\n {avgRating:0.0} / 5";
        }
        downloadText.text = $"Downloads:\n {GetUnits(mapData.downloads)}";
        likeText.text = $"Likes:\n {GetUnits(mapData.likes)}";
    }

    public MapData_Cloud GetMapData()
    {
        return mapData;
    }

    private string GetUnits(int amount)
    {
        if (amount >= 1_000_000)
        {
            return $"{(amount / 1_000_000f):0.#}M";
        }
        else if (amount >= 1_000)
        {
            return $"{(amount / 1_000f):0.#}K";
        }

        return amount.ToString();
    }
}