using UnityEngine;
using System.Collections.Generic;

public class Manager_CurrentCourseIndex : MonoBehaviour
{
    [SerializeField] private CRUD_EasySave3 easySave;
    [SerializeField] private Manager_Level levelManager;
    Dictionary<string, IMapData> maps = null;
    private MapData_ES3 currentMap = null;
    private LocalSaveKeys.SaveType saveType = LocalSaveKeys.SaveType.Local;
    private bool isCloud = false;

    private void Awake()
    {
      isCloud = PlayerPrefs.GetInt("isDownloaded") == 1;
      if (isCloud)
      {
        Debug.Log("Is cloud");
        saveType = LocalSaveKeys.SaveType.Download;
      }
      else
      {
        saveType = LocalSaveKeys.SaveType.Local;
      }
      LoadMapIndexData();
    }

    // Get the current map metadata -> TODOBUG bug, overrided??
    private void LoadMapIndexData()
    {
        maps = GetMapListingInfo();
        string currentItem = PlayerPrefs.GetString(KeyManager.saveKeysDict[KeyManager.SaveKey.EditMapKey]);
        if (maps.ContainsKey(currentItem))
        {
          string author = "Anonymous";
          if (isCloud)
          {
            MapData_Cloud currentMapCloud = (MapData_Cloud)maps[currentItem];
            author = currentMapCloud.mapAuthor;

            Debug.Log("Loading cloud map data" + author);
            currentMap = new MapData_ES3(currentMapCloud.mapName)
            {
              key = currentMapCloud.key,
              name = currentMapCloud.mapName,
              description = currentMapCloud.mapDescription,
              holesPar = new Dictionary<int, HoleInfo>(currentMapCloud.holesPar), // Clone holesPar dictionary
              creationDate = currentMapCloud.creationDate,
              lastModifiedDate = currentMapCloud.lastModifiedDate,
              isUploaded = true, // Assume it's uploaded since it came from the cloud
              isValidated = false // Set default or adjust based on validation logic
            };
          }
          else
          {
            Debug.Log("Loading local map data");
            currentMap = (MapData_ES3)maps[currentItem];
          }
          levelManager.SetLevelName(currentMap.name);
          levelManager.SetLevelAuthor(author);
        }
        else
        {
          Debug.Log("No map data found");
          Debug.Log("TODO handle error");
        }
    }

    // Get the current hole data
    public HoleInfo GetHoleInfo(int index)
    {
      if (currentMap != null)
      {
        if (currentMap.holesPar.ContainsKey(index))
        {
          return currentMap.holesPar[index];
        }
      }
      return null;
    }

    // Given a hole and its par, remove it from the map
    public void RemoveHolesPar(int level)
    {
      if (currentMap.holesPar.ContainsKey(level))
      {
        currentMap.holesPar.Remove(level);
      }
    }

    // Adds a hole if it was not added previously
    public HoleInfo AddHolePar(int level, int par, Transform spawnPoint)
    {

      float x = spawnPoint.position.x;
      float y = spawnPoint.position.y;

      if (currentMap.holesPar.ContainsKey(level))
      {
        currentMap.holesPar[level].posX = x;
        currentMap.holesPar[level].posY = y;
        currentMap.holesPar[level].parValue = par;
        return currentMap.holesPar[level];
      }

      HoleInfo hole = new HoleInfo(par, x, y);
      currentMap.holesPar.Add(level, hole);
      return currentMap.holesPar[level];
    }

    // Given a hole and its par, update it in the map
    public void UpdateHolesPar(int level, int par, Transform spawnPoint)
    {
      float x = spawnPoint.position.x;
      float y = spawnPoint.position.y;

      if (currentMap.holesPar.ContainsKey(level))
      {
        currentMap.holesPar[level].parValue = par;
        currentMap.holesPar[level].posX = x;
        currentMap.holesPar[level].posY = y;
      }
      else
      {
        HoleInfo hole = new HoleInfo(par, x, y);
        currentMap.holesPar.Add(level, hole);
      }
    }

    // Change the key for a specific hole's par value
    public void ChangeHolesParKey(int oldLevel, int newLevel)
    {
        if (currentMap != null && currentMap.holesPar.ContainsKey(oldLevel))
        {
            // Get the par value associated with the old key
            int parValue = currentMap.holesPar[oldLevel].parValue;
            float posX = currentMap.holesPar[oldLevel].posX;
            float posY = currentMap.holesPar[oldLevel].posY;

            // Remove the old key-value pair
            currentMap.holesPar.Remove(oldLevel);

            // Create a new HoleInfo object with the new key
            HoleInfo hole = new HoleInfo(parValue, posX, posY);

            // Add the new key-value pair
            currentMap.holesPar[newLevel] = hole;
        }
        else
        {
            Debug.LogWarning($"Key {oldLevel} not found in holesPar dictionary.");
        }
    }

    // Update the current filesize
    public void UpdateFileSize(long fileSize)
    {
      currentMap.fileSize = CompressionUtility.FormatFileSize(fileSize);
      SaveListingInfo();
    }

    // Save the map listing info
    public void SaveListingInfo()
    {
      currentMap.lastModifiedDate = DateTimeGenerator.GetCurrentDateTime();
      easySave.SaveListingInfo(maps, saveType);
    }

    // Update the verified status of the map
    public void UpdateVerifiedStatus(bool status)
    {
      currentMap.isValidated = status;
      SaveListingInfo();
    }

    // Get the map listing info
    public Dictionary<string, IMapData> GetMapListingInfo()
    {
        return easySave.LoadMapListingInfo(saveType);
    }

    public Dictionary<int, HoleInfo> GetHolesPar()
    {
        return currentMap.holesPar;
    }

  
}