using UnityEngine;
using System.Collections.Generic;

// TODO refactor into try xxx -> catch xxx for error handling?
// This class handles the CRUD of the index file of the maps
public class Manager_IndexData : MonoBehaviour
{
    [SerializeField] private CRUD_EasySave3 easySave;
    [SerializeField] private Interact_MapDataDisplayLocal mapDataDisplay;
    [SerializeField] private Interact_MapDataDisplayCloud mapDataDisplayCloud;
    
    // Create a copy of the map
    public bool CreateCopyOfMap(string originalName, string newName, LocalSaveKeys.SaveType saveType = LocalSaveKeys.SaveType.Local)
    {
        easySave.CreateCopyOfMap(originalName, newName, saveType);
        return true;
    }

    // Update the listing info -> Used also for renaming and 
    public void UpdateListingInfo(LocalSaveKeys.SaveType saveType = LocalSaveKeys.SaveType.Local)
    {
        if (saveType == LocalSaveKeys.SaveType.Local)
        {
            easySave.SaveListingInfo(mapDataDisplay.GetMaps(), saveType);
        }
        else if (saveType == LocalSaveKeys.SaveType.Download)
        {
            easySave.SaveListingInfo(mapDataDisplayCloud.GetMaps(), saveType);
        }
    }

    // Get the map listing info
    public Dictionary<string, IMapData> GetMapListingInfo(LocalSaveKeys.SaveType saveType = LocalSaveKeys.SaveType.Local)
    {
        return easySave.LoadMapListingInfo(saveType);
    }
}