using UnityEngine;
using System.Collections.Generic;

public class Manager_TilesData : MonoBehaviour
{
    [SerializeField] private CRUD_EasySave3 easySave;
    [SerializeField] private Processing_TilesData tilesData;
    [SerializeField] private LocalSaveKeys.SaveType saveType = LocalSaveKeys.SaveType.Local;
    [SerializeField] private Manager_CurrentCourseIndex indexManager; 
    [SerializeField] private bool isOnMenu = true;
    private void Awake()
    {
        if (isOnMenu) return; // When on menu, we don't have to load anything

        tilesData.InitializeTileMapDict();
        saveType = PlayerPrefs.GetInt("isDownloaded") == 1 ? LocalSaveKeys.SaveType.Download : LocalSaveKeys.SaveType.Local;
        LoadMap(saveType);
    }

    // Set the save type -> Local / Download
    public void SetSaveType(LocalSaveKeys.SaveType saveType)
    {
        this.saveType = saveType;
    }

    // Loads the map using the current save type
    public void LoadMap()
    {        
        // If the map doesn't exist, create it using the default map
        if (!TryLoadMap(saveType))
        {   
            Debug.Log("Creating new map");
            SaveMap();
        }
    }
    // Method to load the map
    public void LoadMap(LocalSaveKeys.SaveType saveType)
    {        
        // If the map doesn't exist, create it using the default map
        if (!TryLoadMap(saveType))
        {   
            Debug.Log("Creating new map");
            SaveMap();
        }
    }

    // Tries to load the map
    private bool TryLoadMap(LocalSaveKeys.SaveType saveType)
    {
        // Load the map data
        List<TileMapData> tileMapData = easySave.LoadMapData(saveType);
        
        // Check if the map data is empty which means the map is corrupted
        if (tileMapData.Count == 0)
        {
            Debug.Log("No map data found");
            return false;
        }

        // Clear current tilemaps before loading new data
        tilesData.ClearMap();
        tilesData.SetTileMapData(tileMapData);
        
        Debug.Log("Map loaded successfully");
        return true;
    }

    // Create a new map
    public void SaveMap()
    {
        // Save the map data
        long fileSize = easySave.SaveMapData(tilesData.GetTileMapData());
        indexManager.UpdateFileSize(fileSize);
        Debug.Log("Map saved successfully");
    }

    // Delete the map
    public void DeleteMap(string name, LocalSaveKeys.SaveType saveType)
    {
        easySave.DeleteMapData(name, saveType);
    }

    // Tries to get the map data
    public string GetMapData(string mapName)
    {
        return easySave.LoadRawMapData(mapName, LocalSaveKeys.SaveType.Local);
    }
}