using System;
using UnityEngine;
using UnityEngine.Tilemaps;
using System.Collections.Generic;

public class Processing_TilesData : MonoBehaviour
{
    Dictionary<string, Tilemap> tileMapDict; // Dictionary to hold the tilemaps
    [SerializeField] Tilemap[] tilemaps; // Current tilemaps in the scene

    // Initialize the dictionary with the tilemaps
    public void InitializeTileMapDict()
    {
        tileMapDict = new Dictionary<string, Tilemap>();
        // Adds the tilemaps to the dictionary
        foreach (Tilemap tilemap in tilemaps)
        {
            tileMapDict.Add(tilemap.name, tilemap);
        }
    }

    // Set the tilemap data
    public void SetTileMapData(List<TileMapData> tileMapData)
    {
        // Iterate through each tilemap data
        foreach (TileMapData data in tileMapData)
        {
            // Get the tilemap from the dictionary
            if (tileMapDict.TryGetValue(data.key, out Tilemap tilemap))
            {
                // Iterate through each tile in the tilemap data
                foreach (TileInfo tileInfo in data.tiles)
                {
                    // Set the tile in the tilemap
                    tilemap.SetTile(tileInfo.position, tileInfo.tile);
                }
            }
        }
    }

    // Get the tile map data
    public List<TileMapData> GetTileMapData()
    {
        List<TileMapData> tileMapData = new List<TileMapData>();
        // Iterate through each tilemap in the dictionary
        foreach (var mapObj in tileMapDict)
        {
            TileMapData data = new TileMapData
            {
                key = mapObj.Key,
                tiles = new List<TileInfo>()
            };
            // Get all the positions within the bounds of the tilemap
            foreach (Vector3Int pos in mapObj.Value.cellBounds.allPositionsWithin)
            {
                TileBase tile = mapObj.Value.GetTile(pos);
                // Add only non-null tiles to the list
                if (tile != null)
                {
                    data.tiles.Add(new TileInfo(tile, pos));
                }
            }
            // Add the tile map data to the list
            tileMapData.Add(data);
        }

        return tileMapData;
    }

    // Clear all the tiles in the tilemaps
    public void ClearMap()
    {
        foreach (var mapObj in tileMapDict)
        {
            mapObj.Value.ClearAllTiles();
        }
    }
}