using UnityEngine;
using System;

public class Interact_MapDataDisplayCloud : Interact_MapDisplayBase
{
    private MapData_Cloud currentMap = null;
    [SerializeField] private GameObject noMapsWarning;

    // Instantiate a cloud map display
    protected override void InstantiateMapDisplay(IMapData map)
    {
        MapData_Cloud mapData = map as MapData_Cloud;
        if (mapData != null)
        {
            GameObject newMapDisplay = Instantiate(mapDisplayPrefab, mapsViewport);
            newMapDisplay.GetComponent<Object_MapDisplayCloud>().SetMapData(mapData);
        }
    }

     // Override the LoadMaps method to load only shared maps
    public override void LoadMaps()
    {
        if (maps == null) return;
        noMapsWarning.SetActive(maps.Count == 0);
        // Check if there are any maps to display
        ClearMapsDisplay();
        foreach (IMapData map in maps.Values)
        {
            InstantiateMapDisplay(map);
        }
    }
    
    /****** Specific Operations ******/

    // Check if the map is downloaded
    public bool IsDownloaded(string mapName)
    {
        return maps.ContainsKey(mapName);
    }

    // Get the unique name of the downloaded map
    public void SetCurrentMap(MapData_Cloud map)
    {
        currentMap = map;
    }

    // Get the current map
    public MapData_Cloud GetCurrentMap()
    {
        return currentMap;
    }

    // Get the map key
    public string GetMapKey()
    {
        return currentMap.key;
    }

    // Update the downloaded maps dictionary
    public void UpdateDownloadedMapsDict()
    {
        string mapName = GetMapKey();

        // Update the map if it already exists
        if (maps.ContainsKey(mapName))
        {
            maps[mapName] = currentMap;
        }
        else
        {
            maps.Add(mapName, currentMap);
        }
    }

    // Remove a map from the downloaded maps dictionary
    public void RemoveMap(string mapName)
    {   
        maps.Remove(mapName);
    }

}
