using UnityEngine;
using System.Collections.Generic;

public abstract class Interact_MapDisplayBase : MonoBehaviour
{
    [SerializeField] protected Transform mapsViewport;  // Reference to the viewport where maps are displayed
    [SerializeField] protected GameObject mapDisplayPrefab;  // Reference to the map display prefab
    protected Dictionary<string, IMapData> maps = null;  // Dictionary to hold the map data

    // Set the maps dictionary
    public void SetMaps(Dictionary<string, IMapData> maps)
    {
        this.maps = maps;
    }

    // Get all the maps
    public Dictionary<string, IMapData> GetMaps()
    {
        return maps;
    }

    // Load maps into the viewport
    public virtual void LoadMaps()
    {
        ClearMapsDisplay();
        foreach (IMapData map in maps.Values)
        {
            InstantiateMapDisplay(map);
        }
    }

    // Clear existing maps from the viewport
    protected void ClearMapsDisplay()
    {
        foreach (Transform child in mapsViewport)
        {
            Destroy(child.gameObject);
        }
    }

    // Abstract method to be implemented by child classes
    protected abstract void InstantiateMapDisplay(IMapData map);
}
