using UnityEngine;
public class Manager_Level : MonoBehaviour
{
    [System.Serializable]
    public class Level
    {
        public int levelNum = 0;
        public int parValue = 0;
        public Transform spawnPoint;
    }

    [SerializeField]
    public Level[] levels = null;
    [SerializeField] string levelName = "Level";
    [SerializeField] string levelAuthor = "Anonymous";
    public int currentLevel = 0;
    public int totalLevels;

    public void Start()
    {
        totalLevels = levels.Length;
    }
    
    // Go to the next level
    public void NextLevel()
    {
        SetLevel(++currentLevel);
    }

    // Go to the previous level
    public int GetCurrentLevel() 
    {
        return currentLevel;
    }

    // Get the author of the level
    public string GetLevelAuthor()
    {
        return levelAuthor;
    }

    // Set map name
    public void SetLevelName(string name)
    {
        levelName = name;
    }

    // Set the author of the level
    public void SetLevelAuthor(string author)
    {
        levelAuthor = author;
    }

    // Get the total amount of levels
    public int GetTotalLevels()
    {
        return levels.Length;
    }
    
    // Set the current level with clamping
    public void SetLevel(int levelIndex)
    {
        currentLevel = Mathf.Clamp(levelIndex, 0, levels.Length);
    }
    // Get the current level data
    public Level GetCurrentLevelData()
    {
        return levels[currentLevel];
    }

    // Get the current level par value
    public int GetLevelPar()
    {
        return levels[currentLevel].parValue;
    }

    // Get the given level par value
    public int GetLevelPar(int level)
    {
        return levels[level].parValue;
    }

    // Get Level spawn point
    public Transform GetLevelSpawnPoint()
    {
        return levels[currentLevel].spawnPoint;
    }

    // Get the level name
    public string GetLevelName()
    {
        return levelName;
    }

    // Get the levels of the map
    public Level[] GetLevels()
    {
        return levels;
    }

    // Add a level
    public void AddLevel(Level level)
    {
        if (levels == null)
        {
            levels = new Level[1];
            levels[0] = level;
            currentLevel = 0;
        }
        else
        {
            Level[] temp = new Level[levels.Length + 1];
            for (int i = 0; i < levels.Length; i++)
            {
                temp[i] = levels[i];
            }
            temp[levels.Length] = level;
            levels = temp;
        }
        totalLevels = levels.Length;
    }

    // Remove a level
    public void RemoveLevel(int levelNumToRemove)
    {
        if (levels == null || levels.Length == 0) return;
        if (levelNumToRemove < 0 || levelNumToRemove >= totalLevels)
        {
            return;
        }
        
        // Find the index of the level with the specified level number
        int index = -1;
        for (int i = 0; i < levels.Length; i++)
        {
            if (levels[i].levelNum == levelNumToRemove)
            {
                index = i;
                break;
            }
        }

        if (index == -1)
        {
            Debug.LogWarning($"Level {levelNumToRemove} not found in the list.");
            return;
        }

        // Create a new array without the removed level
        Level[] temp = new Level[levels.Length - 1];
        int tempIndex = 0;

        for (int i = 0; i < levels.Length; i++)
        {
            if (i != index)
            {
                temp[tempIndex] = levels[i];
                if (i > index)
                {
                    temp[tempIndex].levelNum--;
                }
                tempIndex++;
            }
        }

        levels = temp;
        totalLevels = levels.Length;

        if (currentLevel == index)
        {
            currentLevel = Mathf.Max(0, currentLevel - 1);
        }
        else if (index < currentLevel)
        {
            currentLevel--;
        }
        Debug.Log("New curent level wtffff " + currentLevel);
    }

}