using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class UI_LevelHole_Editor : MonoBehaviour
{
    [SerializeField] private TMP_InputField holeNumber; // Reference to the edited name text
    public int minLevels = 1; // Minimum name length
    public int totalLevels;
    public Manager_Level manager_LevelEditor; // Reference to the par text
    public int currentLevel = 1; // Current level
    public Button nextLevelButton; // The menu of settings the level
    public Button previousLevelButton; // The menu of settings the level

    public Button previusLevelButtonEditor; // the editor button 
    public Button nextLevelButtonEditor; // the editor button 

    // Open the menu
    public void UpdateMenu()
    {
        currentLevel = manager_LevelEditor.GetCurrentLevel() + 1;
        totalLevels = manager_LevelEditor.GetTotalLevels();
        holeNumber.text = (currentLevel).ToString();
        ResetHoleNumber();
    }

    // Enable or disable the buttons based on the current level
    public void UpdateEditorButtonLevelState()
    {
        int currentLevel = manager_LevelEditor.GetCurrentLevel();
        int totalLevels = manager_LevelEditor.GetTotalLevels();

        // Disable the previous button if at level 0
        previusLevelButtonEditor.interactable = currentLevel > 0;

        // Disable the next button if at the last level
        nextLevelButtonEditor.interactable = currentLevel < totalLevels - 1;
    }

    // Reset the max or min value of the input field
    public void ResetHoleNumber()
    {
        // Enable both buttons by default
        nextLevelButton.interactable = true;
        previousLevelButton.interactable = true;
        totalLevels = manager_LevelEditor.GetTotalLevels();

        // Check if holeNumber text is empty or not
        int currLevel = string.IsNullOrEmpty(holeNumber.text) ? currentLevel : int.Parse(holeNumber.text);

        // Clamp the current level within the valid range
        currLevel = Mathf.Clamp(currLevel, minLevels, totalLevels);

        // Set the hole number text to the valid clamped level
        holeNumber.text = currLevel.ToString();

        // Disable next or previous button based on the current level
        previousLevelButton.interactable = currLevel > minLevels;
        nextLevelButton.interactable = currLevel < totalLevels;
    }

    // Increase or decrease the par value
    public void AddLevelNum(int value)
    {
        int level = int.Parse(holeNumber.text);
        level += value;
        holeNumber.text = level.ToString();
        ResetHoleNumber();
    }

    // Return the values of the input fields
    public int GetHoleNumber()
    {
        ResetHoleNumber();
        return int.Parse(holeNumber.text);
    }

}