using UnityEngine;
using TMPro;
using UnityEngine.UI;

public class UI_LevelPar_Editor : MonoBehaviour
{
  [SerializeField] private TMP_InputField parValue; // Reference to the edited name text
  public int maxParValue = 23; // Maximum par value
  [SerializeField] private Manager_Level manager_LevelEditor; // Reference to the par text

  public Button addButton; // Reference to the add button
  public Button removeButton; // Reference to the remove button
  public int level = 1;
  
  // Open the menu
  public void UpdateMenu()
  {
    Manager_Level.Level currentLevel = manager_LevelEditor.GetCurrentLevelData();
    level = manager_LevelEditor.GetCurrentLevel() + 1;
    parValue.text = currentLevel.parValue.ToString();
    ResetParValue();
  }

  // Reset the max or min value of the input field
  public void ResetParValue()
  {
    removeButton.interactable = true;
    addButton.interactable = true;
    if (parValue.text == "")
    {
      parValue.text = "1";
      removeButton.interactable = false;
    }
    else
    {
      int parVal = int.Parse(parValue.text);
      if (parVal <= 1)
      {
        parValue.text = "1";
        removeButton.interactable = false;
      }
      else if (parVal >= maxParValue)
      {
        parValue.text = maxParValue.ToString();
        addButton.interactable = false;
      }
    }
  }

  // Increase or decrease the par value
  public void AddParValue(int value)
  {
    int parVal = int.Parse(parValue.text);
    parVal += value;
    parValue.text = parVal.ToString();
    ResetParValue();
  }

  // Return the values of the input fields
  public int GetHoleNumber()
  {
    return level;
  }

  // Retun the par value
  public int GetParValue()
  {
    ResetParValue();
    return int.Parse(parValue.text);
  }

}