using UnityEngine;
using System.Collections;
using TMPro;

public class UI_LevelRegistry : MonoBehaviour
{
  [SerializeField] private TextMeshProUGUI holeNumber; // Reference to the hole number text
  public GameObject levelsummaryMenu;
  public TextMeshProUGUI holeNumberIndicator;
  public enum ScoreTrigger // TODO consider using AnimatorTrigger instead
  {
    Show,
    HideAll,
    ShowCurrentHole
  }
  [SerializeField] private Animator scoreTransmitter;

  public void SetScoreTrigger(string trigger)
  {
    scoreTransmitter.SetTrigger(trigger);
  }

  public void ShowLevelSummary()
  {
    levelsummaryMenu.SetActive(true);
  }

  public void SetHoleNumber(int holeNum, int totalHoles)
  {
    holeNumber.text = "Hole " + holeNum.ToString() + " of " + totalHoles.ToString();
  }

  public void SetHoleNumberIndicator(int holeNum)
  {
    holeNumberIndicator.text = "Hole " + holeNum.ToString();
  }
}
