using UnityEngine;
using TMPro;

// Handles the UI of preparation menu
public class UI_Menu_Preparation : MonoBehaviour
{
  public GameObject[] initatedGameMenus;
  public GameObject closedGameMenu;
  public SpriteRenderer spriteRenderer;
  [SerializeField] private TextMeshProUGUI title; // Reference to a TextMeshProUGUI for displaying the timer
  [SerializeField] private TextMeshProUGUI author;
  [SerializeField] private TextMeshProUGUI holes;

  public void SetGameMenus(bool state)
  {
    foreach (GameObject menu in initatedGameMenus)
    {
      menu.SetActive(state);
    }
    closedGameMenu.SetActive(!state);
    spriteRenderer.enabled = state;
  }

  public void SetTitle(string titleText)
  {
    title.text = titleText;
  }

  public void SetAuthorText(string authorText)
  {
    author.text = authorText;
  }

  public void SetHolesText(string holesText)
  {
    holes.text = holesText;
  }
}
