using UnityEngine;
using TMPro;
using UnityEngine.UI;

public class UI_ResultsMenu : MonoBehaviour
{
  [SerializeField] private GameObject resultPrefab;
  public Transform resultParent;
  [SerializeField] private TextMeshProUGUI finalScore; // Reference to the score text
  [SerializeField] private TextMeshProUGUI totalTime; // Reference to the total time text
  
  [SerializeField] private TextMeshProUGUI totalStrokes;
  [SerializeField] private TextMeshProUGUI totalPar;
  public TextMeshProUGUI[] stars;
  public TextMeshProUGUI timeRating;
  public Image[] starAchieved;
  public Image timeAchieved;
  private int[] ratings = new int[3];
  private float time;

  // Set the score text for the given hole
  public void SetStarRatings(int[] ratings, float time)
  {
    for (int i = 0; i < ratings.Length; i++)
    {
      stars[i].text = ratings[i].ToString();
    }

    timeRating.text = SecToMin(time) + " min";

    this.ratings = ratings;
    this.time = time;
  }

  public string SecToMin(float time)
  {
    int min = Mathf.FloorToInt(time / 60);
    int sec = Mathf.FloorToInt(time % 60);
    return min.ToString("00") + ":" + sec.ToString("00");
  }

  // Set the star achieved for the given hole
  public void SetStarAchieved(int totalStrokes, float totalTime)
  {
    for (int i = 0; i < ratings.Length; i++)
    {
      starAchieved[i].enabled = ratings[i] >= totalStrokes;
    }
    if (time >= totalTime)
    {
      timeAchieved.enabled = true;
    }
    else
    {
      timeAchieved.enabled = false;
    }
  }

  // Create a new result prefab and add it to the parent
  public void AddHoleResult(string hole, int par, int strokes)
  {
    GameObject result = Instantiate(resultPrefab, resultParent);
    result.GetComponent<Prefab_Results>().SetResult(hole, par, strokes);
    UpdateParentSize();
  }

  // Update the width of the scroll view content
  private void UpdateParentSize()
  {
    if (resultParent.childCount > 4)
    {
      RectTransform parentRect = resultParent.GetComponent<RectTransform>();
      Vector2 newOffsetMax = parentRect.offsetMax;
      newOffsetMax.x += 70; // Negative value moves inward from the right
      parentRect.offsetMax = newOffsetMax;
    }
  }

  // Set the final score text
  public void SetFinalScore(int score)
  {
    finalScore.text = "Score: " + score.ToString();
  }

  // Set the total time text
  public void SetTotalTime(string time)
  {
    totalTime.text = "Total Time: " + time + " min";
  }

  // Set the total strokes text
  public void SetTotalStrokes(int strokes)
  {
    totalStrokes.text = strokes.ToString();
  }

  // Set the total par text
  public void SetTotalPar(int par)
  {
    totalPar.text = par.ToString();
  }
}