using UnityEngine;
using UnityEngine.UI;

public class BuildingButtonHandler : MonoBehaviour
{
    // Reference to the button component
    private Button buildingButton;
    // The previously selected building object
    private BuildingObjectBase prevItem;
    // Reference to the BuildingCreator instance
    private BuildingCreator buildingCreator;
    // Boolean to track if an item is selected
    private bool hasItem = false;

    // Reference to the player collider
    [SerializeField] private GameObject player;
    public ItemToolTip itemToolTip;

    // No item index
    private int noItemIndex = -23;

    // Awake is called when the script instance is being loaded
    private void Awake()
    {
        // Get the Button component attached to this GameObject
        buildingButton = GetComponent<Button>();
        // Get the BuildingCretor attached to the BuildingCreator GameObject
        buildingCreator = GetComponent<BuildingCreator>();
        // Set the exploring mode in PlayerPrefs based on hasItem
        //PlayerPrefs.SetInt(KeyManager.saveKeysDict[KeyManager.SaveKey.ExploringMode], hasItem ? 0 : 1);
        // Initialize prevItem with the current item
        prevItem = null;
    }

    // TODO refactor this method
    // Method to handle button clicks
    public void OnClickBuildingButton(BuildingObjectBase item)
    {
        // Toggle hasItem if the same item is clicked
        if (prevItem == item)
        {
            Debug.Log("Is this even called?");
            hasItem = false;
            prevItem = null;
        }
        else
        {
            Debug.Log("Or is this called?");
            prevItem = item;
            hasItem = true;
        }

        bool useItem = hasItem? true : false;
        Debug.Log("useItem: " + useItem);
        PlayerPrefs.SetInt("isPaused", useItem ? 1 : 0);
        // Select or deselect the building object in BuildingCreator
        buildingCreator.ObjectSelected(hasItem ? item : null);
        // Update the exploring mode in PlayerPrefs based on hasItem
        //PlayerPrefs.SetInt(KeyManager.saveKeysDict[KeyManager.SaveKey.ExploringMode], hasItem ? 0 : 1);
        if (!hasItem)
        {
            // Set the player collider to inactive
            itemToolTip.CloseToolTip();
        }
    }

    // Cancel building selection
    public void CancelBuildingSelection()
    {
        // Deselect the building object in BuildingCreator
        buildingCreator.ObjectSelected(null);
        // Update the exploring mode in PlayerPrefs
        //PlayerPrefs.SetInt(KeyManager.saveKeysDict[KeyManager.SaveKey.ExploringMode], 0);
        PlayerPrefs.SetInt("isPaused", 0);
        hasItem = false;
        prevItem = null;
        UpdateSelectedMarker(noItemIndex);
        itemToolTip.CloseToolTip();
    }

    // Update the selected marker
    public void UpdateSelectedMarker(int index)
    {
        // Remove the item if clicked again
        if (hasItem == false)
        {
            index = noItemIndex;
            player.SetActive(true);
        }
        else
        {
            player.SetActive(false);
        }
        // Find all the game objects with the script "BuildItemSelector"
        BuildItemSelector[] buildItemSelectors = FindObjectsOfType<BuildItemSelector>();

        // Iterate through all the game objects with the script "BuildItemSelector"
        foreach (BuildItemSelector selector in buildItemSelectors)
        {
            // If the index of the BuildItemSelector is the same as the index of the current BuildItemSelector
            if (selector.index == index)
            {
                // Set the selected marker to true
                selector.SetSelected(true);
            }
            else
            {
                // Set the selected marker to false
                selector.SetSelected(false);
            }
        }
    }
}
