using UnityEngine;
using UnityEngine.UI;

public class BuildingHistoryHandler : MonoBehaviour
{
    // Serialize fields to assign the undo and redo buttons in the Unity Editor
    [SerializeField] private Button undoButton, redoButton;

    // Reference to the BuildingHistory instance
    private BuildingHistory history;

    // Awake is called when the script instance is being loaded
    private void Awake()
    {
        // Add listeners to the undo and redo buttons
        undoButton.onClick.AddListener(Undo);
        redoButton.onClick.AddListener(Redo);

        // Initialize the history instance
        history = GetComponent<BuildingHistory>();
    }

    // Method to undo the last action
    private void Undo()
    {
        history.UndoStep();
    }

    // Method to redo the last undone action
    private void Redo()
    {
        history.RedoStep();
    }
}
