using UnityEngine;
// Class to store item data

// ScriptableObject class to define properties and behaviors for building objects
[CreateAssetMenu(fileName = "NewBuildingItemData", menuName = "Custom/Building Object Data")]
public class BuildingItemsData : ScriptableObject
{
    // TODO, maybe merge with BuildingObjectBase?
    [System.Serializable]
    public struct BuildingItem
    {
        public string name;
        public string description;
        public Sprite itemIcon;
        public BuildingObjectBase buildingObject;
    }

    [SerializeField] private BuildingItem[] items;

    public BuildingItem GetItem(int index)
    {
        if (index < 0 || index >= items.Length)
        {
            Debug.LogError("Index out of range");
            return default;
        }
        return items[index];
    }
}
