using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class BuildingTutorialHandler : MonoBehaviour
{
    [SerializeField] private GameObject[] buildingTutorials;
    private int currentTutorialIndex = 0;
    [SerializeField] private GameObject buildingTutorial;
    [SerializeField] private TMP_Text index;

    private void Start()
    {
        // Don't show tutorial if the player has already skipped it or is in verify mode (play mode)
        if (PlayerPrefs.GetInt("SkipTutorial") == 1 || PlayerPrefs.GetInt("isVerifyMode") == 1)
        {
            buildingTutorial.SetActive(false);
            return;
        }
    }

    public void SkipTutorial()
    {
        buildingTutorial.SetActive(false);
        PlayerPrefs.SetInt("SkipTutorial", 1);
    }

    public void NextBuildingTutorial()
    {
        currentTutorialIndex = (currentTutorialIndex + 1) % buildingTutorials.Length;
        index.text = (currentTutorialIndex + 1) + "/" + buildingTutorials.Length;
        ShowBuildingTutorial(currentTutorialIndex);
    }
    public void PreviousBuildingTutorial()
    {
        currentTutorialIndex = (currentTutorialIndex - 1 + buildingTutorials.Length) % buildingTutorials.Length;
        index.text = (currentTutorialIndex + 1) + "/" + buildingTutorials.Length;
        ShowBuildingTutorial(currentTutorialIndex);
    }
    public void ShowBuildingTutorial(int index)
    {
        foreach (var tutorial in buildingTutorials)
        {
            tutorial.SetActive(false);
        }

        buildingTutorials[index].SetActive(true);
    }
}