using UnityEngine;
using UnityEngine.UI;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System;

public class BuildItemSelector : MonoBehaviour
{

    public BuildingButtonHandler buildingCreator;
    public BuildingItemsData buildingItemsData;
    public BuildingObjectBase buildingObject; // In the future we should get the index here
    public BuildingCreator creatorBuilding;
    public int index;
    public Image imageSelectedMarker;
    private ItemToolTip itemToolTip;
    public Image icon;
    public Button button;
    public bool isSelected = false;

    void Start()
    {
        buildingCreator = FindObjectOfType<BuildingButtonHandler>();
        itemToolTip = FindObjectOfType<ItemToolTip>();
        creatorBuilding = FindObjectOfType<BuildingCreator>();
        creatorBuilding.OnObjectRotated += UpdateSprite;
        imageSelectedMarker.enabled = false;
        index = buildingObject.itemIndex;
        button.onClick.AddListener(OnClick);
    }

    // Handle button clicks
    public void OnClick()
    {
        buildingCreator.OnClickBuildingButton(buildingObject);
        buildingCreator.UpdateSelectedMarker(buildingObject.itemIndex);
    }

    // Update the sprite based on the rotation
    public void UpdateSprite(bool a)
    {
        if (buildingObject.HasRotation && isSelected)
        {
            icon.sprite = buildingObject.GetTileSprite();
        }
    }

    // Set the selected marker
    public void SetSelected(bool selected)
    {
        imageSelectedMarker.enabled = selected;
        if (selected)
        {
            itemToolTip.UpdateToolTip(buildingItemsData.GetItem(index).name, buildingItemsData.GetItem(index).description);
        }
        isSelected = selected;
    }

}