using UnityEngine;

// This class is used to set the game objects in the level
public class GameSetters : MonoBehaviour
{
    [SerializeField] private KeyManager.ObjectType objectType = KeyManager.ObjectType.Meta;

    private Manager_Game gameManager;
    [SerializeField] private float threshold = 20f;
    private float originalCaptureRange = 20f;

    // TODO SPRINT 8!!! separate the code using abstract and then implement the specific logic in the child classes
    private void Awake()
    {
        gameManager = (Manager_Game)Object.FindAnyObjectByType<Manager_Game>();
    }

    public float GetThreshold()
    {
        return originalCaptureRange;
    }

    public void ResetThreshold()
    {
        threshold = originalCaptureRange;
    }
    public void SetThreshold(float value)
    {
        threshold = value;
    }

    private void CheckBallFalling(Collider2D collision)
    {

        Rigidbody2D rb = collision.GetComponent<Rigidbody2D>();

        if (rb != null)
        {
            float velocity = rb.linearVelocity.magnitude;
            Debug.Log("Velocity is: " + velocity);
            if (velocity < threshold)
            {
                gameManager.NextLevel();
                Debug.Log("Next Level: Ball velocity is below threshold!");
            }
        }
        else
        {
            Debug.LogWarning("No Rigidbody2D found on the colliding object.");
        }
    }

    void OnTriggerEnter2D(Collider2D collision)
    {
        // If the player collides with the object, trigger the object's function
        if (collision.gameObject.CompareTag("Player"))
        {
            switch (objectType)
            {
                case KeyManager.ObjectType.Meta:
                    CheckBallFalling(collision);
                    break;
                /* case KeyManager.ObjectType.CheckPoint:
                    gameManager.SetCheckPoint(transform);
                    Debug.Log("CheckPoint!");
                    break; */
                case KeyManager.ObjectType.Booster:
                    Debug.Log("Booster!");
                    break;
                case KeyManager.ObjectType.DeadZone:
                    gameManager.ResetLevel();
                    Debug.Log("DeadZone!");
                    break;
            }
        }
    }





}
