using UnityEngine;

public class LevelSetter : MonoBehaviour
{
    [SerializeField] Manager_Game managerLevel;
    [SerializeField] Manager_LevelEditor managerLevelEditor;
    [SerializeField] Manager_CurrentCourseIndex managerCurrentCourseIndex;
    Manager_Level.Level level;
    private bool isEditorMode = true;

    private void Awake()
    {
        GameObject managers = GameObject.FindWithTag("Managers");

        managerLevelEditor = managers.GetComponent<Manager_LevelEditor>();
        if (managerLevelEditor == null)
        {
            isEditorMode = false;
        }
        managerLevel = managers.GetComponent<Manager_Game>();
        managerCurrentCourseIndex = managers.GetComponent<Manager_CurrentCourseIndex>();
    }

    private void Start()
    {
        // Avoid doing the logic when instantiating the preview object
        Transform parentTransform = transform.parent;

        // Parent exists and its name is not "Preview"
        if (parentTransform != null && parentTransform.name != "Preview")
        {
            AddLevelData();
        }
    }

    // Add the level data to the managerLevel and update the amount of levels in the managerLevelEditor
    private void AddLevelData()
    {
        int totalLevels = managerLevel.GetTotalLevels();
        int levelNum = totalLevels + 1;
        HoleInfo holeData = managerCurrentCourseIndex.GetHoleInfo(levelNum);
        int parValue = 1;
        
        if (holeData != null)
        {
            parValue = holeData.parValue;
            gameObject.transform.position = new Vector3(holeData.posX, holeData.posY, 0);
        }

        level = new Manager_Level.Level
        {
            levelNum = levelNum,
            spawnPoint = gameObject.transform,
            parValue = parValue
        };

        managerLevel.AddLevel(level);
        if (isEditorMode)
        {
            managerLevelEditor.AddLevel(level, gameObject);
        }
    }

    // Cleanup level data when the object is destroyed
    private void OnDestroy()
    {
        if (level == null)
        {
            return;
        }
        managerLevel.RemoveLevel(level.levelNum);
        if (isEditorMode)
        {
            managerLevelEditor.RemoveLevel(level.levelNum);
        }
    }

}