using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.EventSystems;

public class EdgeCameraScroll : MonoBehaviour
{
    private Camera cam;

    [SerializeField] private float moveSpeed = 5f;
    [SerializeField] private float screenEdgePercent = 0.1f; // 10% of screen size

    void Start()
    {
        cam = Camera.main;
        Application.targetFrameRate = 60;
    }

    void Update()
    {
#if UNITY_EDITOR || UNITY_STANDALONE
        HandleMouseMovement();
#else
        HandleTouchMovement();
#endif
    }

     private void HandleMouseMovement()
    {
        Vector3 moveDir = Vector3.zero;
        Vector3 mousePos = Input.mousePosition;

        float borderX = Screen.width * screenEdgePercent;
        float borderY = Screen.height * screenEdgePercent;

        if (mousePos.x <= borderX) moveDir.x = -1;
        else if (mousePos.x >= Screen.width - borderX) moveDir.x = 1;

        if (mousePos.y <= borderY) moveDir.y = -1;
        else if (mousePos.y >= Screen.height - borderY) moveDir.y = 1;

        cam.transform.position += moveDir.normalized * moveSpeed * Time.deltaTime;
    }

    private void HandleTouchMovement()
    {
        if (Input.touchCount == 0) return;

        Touch touch = Input.GetTouch(0);
        Vector3 moveDir = Vector3.zero;
        Vector2 touchPos = touch.position;

        float borderX = Screen.width * screenEdgePercent;
        float borderY = Screen.height * screenEdgePercent;

        if (touchPos.x <= borderX) moveDir.x = -1;
        else if (touchPos.x >= Screen.width - borderX) moveDir.x = 1;

        if (touchPos.y <= borderY) moveDir.y = -1;
        else if (touchPos.y >= Screen.height - borderY) moveDir.y = 1;

        cam.transform.position += moveDir.normalized * moveSpeed * Time.deltaTime;
    }
}
