using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ObjectFollower : MonoBehaviour
{
	public Transform target;

	public float smoothSpeed = 0.125f;
	public Vector3 offset;

	public bool isLocal;

  	public bool follow = false;
	
	void Start()
	{
		Application.targetFrameRate = 60; // Or higher, depending on device capability
	}

	// Switches the follow state
	public void SwitchFollow()
	{
		follow = !follow;
	}

	// Sets the follow state
	public void SetFollow(bool follow)
	{
		if (follow == this.follow) return;
		this.follow = follow;
	}

	// Smoothly follows the target
	void FixedUpdate()
	{
		if (!follow) return;
		
		Vector3 desiredPosition = target.position + offset;
		Vector3 smoothedPosition = Vector3.Lerp(transform.position, desiredPosition, smoothSpeed);

		if (isLocal)
			transform.localPosition = smoothedPosition;
		else
			transform.position = smoothedPosition;
	}

	// Returns the time it takes to reach the target position
	public float GetTimeToTarget()
	{
		Vector3 start = transform.position;
		Vector3 end = target.position + offset;
		float distance = Vector3.Distance(start, end);
		// Assuming smoothSpeed is the fraction of distance covered per frame
		// Number of frames to reduce the distance to a negligible amount (e.g., 1%)
		float epsilon = 0.01f; // 1% of the original distance
		int frames = Mathf.CeilToInt(Mathf.Log(epsilon / distance) / Mathf.Log(1 - smoothSpeed));

		// Assuming a frame rate of 60 frames per second
		float frameRate = 60f;
		float time = frames / frameRate;

		return time;
	}

	// Ensures that the camera is at the target position
	public void SetPositionToTarget()
	{
		transform.position = target.position + offset;
	}

	// Returns whether the camera is following the target
	public bool IsFollowing()
	{
		return follow;
	}
}
