using UnityEngine;

public class ObjectProperties : MonoBehaviour
{
    [SerializeField] Vector3 scale;

    [SerializeField] SpriteRenderer spriteRenderer;

    // This class sets the objects starting properties such as scale
    private void Start()
    {
        Transform objectTransform = gameObject.transform;
        objectTransform.localScale = scale;

        // Avoid doing the logic when instantiating the preview object
        Transform parentTransform = transform.parent;

        // Parent exists and its name is not "Preview"
        if (parentTransform != null && parentTransform.name != "Preview")
        {
            spriteRenderer = GetComponent<SpriteRenderer>();
            if (spriteRenderer != null)
            {
                spriteRenderer.enabled = true;
            }           
        }
    }
    
}