using UnityEngine;
using System.Collections;

// Handles the preparation of the map data
public class Manager_Preparation : MonoBehaviour
{
  public UI_Menu_Preparation uiMenuPreparation;
  public Manager_Level levelManager;
  public TimeController timeController;

  public void Start()
  {
    StartCoroutine(Initialize());
  }

  private IEnumerator Initialize()
  {
    yield return new WaitForSecondsRealtime(0.1f);
    UpdateUI();
  }

  public void UpdateUI()
  { 
    string titleText = levelManager.GetLevelName();
    string authorText = "By: " + levelManager.GetLevelAuthor();
    string totalHoles = levelManager.GetTotalLevels().ToString();
    int currentLevel = levelManager.GetCurrentLevel() + 1;
    string holesText = "Total holes: " + totalHoles;
    Debug.Log("Title: " + titleText + " Author: " + authorText + " Holes: " + holesText);
    uiMenuPreparation.SetTitle(titleText);
    uiMenuPreparation.SetAuthorText(authorText);
    uiMenuPreparation.SetHolesText(holesText);
  }

  public void SetGameMenus(bool state)
  {
    uiMenuPreparation.SetGameMenus(state);
  }

  public void SetGameStarted(bool state)
  {
    timeController.SetGameStarted(state);
  }

  // Other logic....
}