using TMPro;
using UnityEngine;
using UnityEngine.UI;

public class UI_Authentication : MonoBehaviour
{
    public TMP_InputField email;
    public TMP_InputField password;
    public TMP_InputField nickname;

    public TMP_InputField emailLogin;
    public TMP_InputField passwordLogin;

    public TMP_Text displayName;
    public TMP_Text userName;
    public TMP_Text userID;

    [SerializeField] private GameObject authPanel;
    [SerializeField] private GameObject registerButton;
    [SerializeField] private GameObject registerPanel;
    [SerializeField] private GameObject userDisplay;
    [SerializeField] private GameObject userMenu;

    public ErrorHandler emailError;
    public ErrorHandler passwordError;
    public ErrorHandler nicknameError;
    public ErrorHandler emailLoginError;
    public ErrorHandler passwordLoginError;

    public GameObject verificationPanel;
    public ErrorHandler verificationError;
    public Button copyIDButton;
    public Warning warning;

    // Updates the display name and short ID of the user
    public void UpdatePanels(string name, string id)
    {
        displayName.text = name;
        userName.text = "Name: " + name;
        userID.text = "ID: " + id;
        copyIDButton.onClick.RemoveAllListeners();
        copyIDButton.onClick.AddListener(() =>
        {
            GUIUtility.systemCopyBuffer = id;
            warning.ShowWarning("User ID copied to clipboard!", Warning.WarningType.Positive);
            Debug.Log("User ID copied to clipboard: " + id);
        });

        // TODO Save the data using player prefs -> related to login US...
        
        registerPanel.SetActive(false);
        authPanel.SetActive(false);
        SetAuthPanelsState(true);
    }

    // Shows the verification panel
    public void ShowVerificationPanel()
    {
        verificationPanel.SetActive(true);
    }

    // Shows the verification error
    public void DisplayVerificationError(string message)
    {
        verificationError.ShowError(message);
    }

    // Cleans the login errors
    public void CleanLoginErrors()
    {
        emailLoginError.HideError();
        passwordLoginError.HideError();
    }

    // Shows the login errors
    public void DisplayLoginError(string message, int errorType)
    {
        if (errorType == 0)
        {
            emailLoginError.ShowError(message);
        }
        else
        {
            passwordLoginError.ShowError(message);
        }
    }

    // Shows the register errors
    public void DisplayRegisterError(string message, int errorType)
    {
        if (errorType == 0)
        {
            emailError.ShowError(message);
        }
        else if (errorType == 1)
        {
            passwordError.ShowError(message);
        }
        else
        {
            nicknameError.ShowError(message);
        }
    }

    // Sets the state of the auth panels
    public void SetAuthPanelsState(bool isRegistered)
    {
        registerButton.SetActive(!isRegistered);
        userDisplay.SetActive(isRegistered);
    }

    // Cleans the input fields
    public void CleanInputFields()
    {
        email.text = "";
        password.text = "";
        nickname.text = "";
        emailLogin.text = "";
        passwordLogin.text = "";
    }

    // Checks if the login fields are empty
    public bool HasEmptyLoginFields()
    {
        if (string.IsNullOrEmpty(emailLogin.text))
        {
            DisplayLoginError("Email is required", 0);
            return true;
        }
        else if (string.IsNullOrEmpty(passwordLogin.text))
        {
            DisplayLoginError("Password is required", 1);
            return true;
        }
        return false;
    }

    // Checks if the register fields are empty
    public bool HasEmptyRegisterFields()
    {
        if (string.IsNullOrEmpty(email.text))
        {
            DisplayRegisterError("Email is required", 0);
            return true;
        }
        else if (string.IsNullOrEmpty(password.text))
        {
            DisplayRegisterError("Password is required", 1);
            return true;
        }
        else if (password.text.Length < 8)
        {
            DisplayRegisterError("Password must be at least 8 characters long", 1);
            return true;
        }
        else if (string.IsNullOrEmpty(nickname.text))
        {
            DisplayRegisterError("Nickname is required", 2);
            return true;
        }
        return false;
    }

    // Show the register panel
    public void ShowLoginPanel()
    {
        registerPanel.SetActive(false);
        authPanel.SetActive(true);
    }
}
