﻿using System.Collections;
using UnityEngine;
using UnityEngine.Events;
using Firebase;
using Firebase.Firestore;
using Firebase.Extensions;
using Firebase.Storage;
using Firebase.Auth;

public class FirebaseInitializer : MonoBehaviour
{
    public UnityEvent onFirebaseInitialized;

    private FirebaseFirestore db;
    private FirebaseStorage storage;
    private FirebaseAuth auth;
    [SerializeField] private CRUD_Authentication authFirebase;
    [SerializeField] private CloudMapFetch cloudMapFetch;
    [SerializeField] private CRUD_Firestore crudFirestore;
    [SerializeField] private CRUD_Storage crudStorage;

    private bool isInitialized = false;

    private void Awake()
    {
        // TODO, change to call init connection after auth
        StartCoroutine(CheckAndFixDependenciesCoroutine());
    }

    // Check and fix dependencies
    private IEnumerator CheckAndFixDependenciesCoroutine()
    {
        var checkDependenciesTask = Firebase.FirebaseApp.CheckAndFixDependenciesAsync();
        yield return new WaitUntil(() => checkDependenciesTask.IsCompleted);

        var dependencyStatus = checkDependenciesTask.Result;
        if (dependencyStatus == Firebase.DependencyStatus.Available)
        {
            Debug.Log($"Firebase: {dependencyStatus} :)");
            db = FirebaseFirestore.DefaultInstance;
            auth = FirebaseAuth.DefaultInstance;
            storage = FirebaseStorage.GetInstance("gs://golfever-b6f24.firebasestorage.app");
            onFirebaseInitialized.Invoke();
        }
        else
        {
            Debug.LogError(System.String.Format("Could not resolve all Firebase dependencies: {0}", dependencyStatus));
            // Firebase Unity SDK is not safe to use here.
        }
    }

    // Get Firestore reference
    public FirebaseFirestore GetFirestoreRef()
    {
        return db;
    }

    public void InitializeFirebase()
    {       
        if (db != null)
        {
            Debug.Log("Firestore is initialized.");
            authFirebase.SetAuthRef(auth);
            cloudMapFetch.SetFirestoreRef(db);
            crudFirestore.SetFirestoreRef(db);
            crudStorage.SetStorageRef(storage);

            isInitialized = true;
        }
        else
        {
            // TODO retry connection or smth
            Debug.LogError("An error has ocurred! Trying again!");
        }
    }

    public bool GetIsInitialized()
    {
        return isInitialized;
    }
    
}