using UnityEngine;
using System.Linq;
using System.Collections.Generic;

public class Interact_LobbyPlayerDisplay : MonoBehaviour
{
    [SerializeField] private Transform playersViewport;  // Reference to the viewport where players are displayed
    [SerializeField] private GameObject playerDisplayPrefab;  // Reference to the player display prefab
    private List<PlayerData> players = new List<PlayerData>();

    // Set the players list
    public void SetPlayers(List<PlayerData> players)
    {
      this.players = players;
      SortPlayers();
    }

    // Add a new player
    public void AddPlayer(PlayerData newPlayer)
    {
      players.Add(newPlayer);
      SortPlayers();
    }

    // Remove a player
    public void RemovePlayer(PlayerData player)
    {
      players.Remove(player);
      SortPlayers();
    }

    // Ensure host is at index 0, and others are sorted
    private void SortPlayers()
    {
      players = players
          .OrderByDescending(p => p.isHost)  // Host first (assuming isHost is a boolean)
          .ToList();
    }

    // Get players list
    public List<PlayerData> GetPlayers()
    {
      return players;
    }

    // Load players into the viewport
    public void LoadPlayers()
    {
      ClearPlayersDisplay();
      foreach (PlayerData player in players)
      {
          InstantiateplayerDisplay(player);
      }
    }

    // Clear map 
    public void ClearPlayers()
    {
      players.Clear();
    }

    // Clear existing players from the viewport
    public void ClearPlayersDisplay()
    {
      foreach (Transform child in playersViewport)
      {
          Destroy(child.gameObject);
      }
    }

    // Abstract method to be implemented by child classes
     // Instantiate a local player display
    public void InstantiateplayerDisplay(PlayerData player)
    {
      if (player != null)
      {
          GameObject newplayerDisplay = Instantiate(playerDisplayPrefab, playersViewport);
          newplayerDisplay.GetComponent<Object_PlayerDisplay>().SetPlayerData(player);
      }
    }
}
