using UnityEngine;
using System.Linq;
using System.Collections.Generic;

public class Interact_ServerDisplay : MonoBehaviour
{
  [SerializeField] private Transform serversViewport;  // Reference to the viewport where servers are displayed
  [SerializeField] private GameObject serverDisplayPrefab;  // Reference to the server display prefab
  private List<ServerData> servers = new List<ServerData>();

  // Set the servers list
  public void SetServers(List<ServerData> servers)
  {
    this.servers = servers;
    SortServers();
  }

  // Add a new server
  public void AddServer(ServerData newserver)
  {
    servers.Add(newserver);
    SortServers();
  }

  // Remove a server
  public void RemoveServer(ServerData server)
  {
    servers.Remove(server);
    SortServers();
  }

  // Ensure host is at index 0, and others are sorted
  private void SortServers()
  {
    servers = servers
        .OrderByDescending(p => p.spaceLeft)  // Host first (assuming isHost is a boolean)
        .ToList();
  }

  // Get servers list
  public List<ServerData> GetServers()
  {
    return servers;
  }

  // Load servers into the viewport
  public void LoadServers()
  {
    ClearServersDisplay();
    foreach (ServerData server in servers)
    {
      InstantiateserverDisplay(server);
    }
  }

  // Clear servers list
  public void ClearServers()
  {
    servers.Clear();
  }

  // Clear existing servers from the viewport
  public void ClearServersDisplay()
  {
    foreach (Transform child in serversViewport)
    {
        Destroy(child.gameObject);
    }
  }

  // Abstract method to be implemented by child classes
    // Instantiate a local server display
  public void InstantiateserverDisplay(ServerData server)
  {
    if (server != null)
    {
        GameObject newserverDisplay = Instantiate(serverDisplayPrefab, serversViewport);
        newserverDisplay.GetComponent<Object_ServerDisplay>().SetServerData(server);
    }
  }
}
