using UnityEngine;
using TMPro;
using Unity.Services.Core;
using Unity.Services.Lobbies;
using Unity.Services.Lobbies.Models;
public class Manager_Server : MonoBehaviour
{
  [SerializeField] private Mult_Lobby multLobby;
  [SerializeField] private Interact_ServerDisplay interactServerDisplay;
  [SerializeField] private GameObject noServerIndicator;
  [SerializeField] private Warning warning;

  // Update the players in the lobby
  public void UpdateServers(QueryResponse query)
  {
    // Clear the servers before updating
    interactServerDisplay.ClearServers();
    interactServerDisplay.ClearServersDisplay();

    if (query.Results.Count == 0)
    {
      noServerIndicator.SetActive(true);
    }
    else
    {
      noServerIndicator.SetActive(false);
    }

    foreach (Lobby lobby in query.Results)
    {
      int playerCount = lobby.Players.Count;
      int maxPlayers = lobby.MaxPlayers;
      // Create the player object
      ServerData serverData = new ServerData();
      serverData.serverId = lobby.Id;
      serverData.serverName = lobby.Name;
      serverData.lobbyStatus = lobby.Data["LobbyStatus"].Value;
      serverData.mapName = lobby.Data["MapName"].Value;
      serverData.mapId = lobby.Data["MapId"].Value;
      serverData.playerCapacity =  playerCount + "/" + maxPlayers;
      serverData.spaceLeft = maxPlayers - playerCount;

      // Add the player to the list
      interactServerDisplay.AddServer(serverData);
    }
    interactServerDisplay.LoadServers();
  }

  // Load the public servers
  public async void LoadPublicServers()
  {
    // Look for public servers
    QueryResponse queryResponse = await multLobby.ListLobbies();

    if (queryResponse != null)
    {
      // Update the listed servers
      UpdateServers(queryResponse);
    }
    else
    {
      warning.ShowWarning("Failed to retrieve the public servers.", Warning.WarningType.Negative);
    }
  }

}