using UnityEngine;
using Unity.Netcode;

public class Mult_PlayerNetwork : NetworkBehaviour
{
    public float moveSpeed = 5f; // Speed of movement
    private NetworkVariable<int> num = new NetworkVariable<int>(0, NetworkVariableReadPermission.Everyone, NetworkVariableWritePermission.Owner); // ID of the player
    

    public void Start()
    {
       Debug.Log("Player ID: " + OwnerClientId);
    }
    void Update()
    {
        if (!IsOwner) return; // Only the local player can move

        // Get input from the player
        float moveX = 0f;
        float moveY = 0f;

        // Check for W (up) or S (down) input
        if (Input.GetKey(KeyCode.W))
        {
            moveY = 1f; // Move up
        }
        else if (Input.GetKey(KeyCode.S))
        {
            moveY = -1f; // Move down
        }

        // Check for A (left) or D (right) input
        if (Input.GetKey(KeyCode.A))
        {
            moveX = -1f; // Move left
        }
        else if (Input.GetKey(KeyCode.D))
        {
            moveX = 1f; // Move right
        }

        // Normalize the movement vector to prevent faster diagonal movement
        Vector2 movement = new Vector2(moveX, moveY).normalized;

        // Move the object
        transform.Translate(movement * moveSpeed * Time.deltaTime);
    }
}
