using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class Object_ServerDisplay : MonoBehaviour
{
  [SerializeField] private TextMeshProUGUI serverName;
  [SerializeField] private TextMeshProUGUI lobbyStatus;
  [SerializeField] private TextMeshProUGUI serverMapName;
  [SerializeField] private TextMeshProUGUI serverPlayerCount;

  [SerializeField] private Manager_Lobby managerLobby;


  ServerData serverData;

  public void Awake()
  {
    managerLobby = FindObjectOfType<Manager_Lobby>();
  }
  public void SetServerData(ServerData sData)
  {
    this.serverData = sData;
    serverName.text = sData.serverName;
    lobbyStatus.text = sData.lobbyStatus;
    serverMapName.text = sData.mapName;
    serverPlayerCount.text = sData.playerCapacity;
  }
  public void JoinLobby()
  {
    managerLobby.JoinServerById(serverData.serverId);
  }
}