using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class Object_PlayerDisplay : MonoBehaviour
{
  [SerializeField] private TextMeshProUGUI playerName;
  [SerializeField] private Image hostIndicator;

  PlayerData playerData;

  public void SetPlayerData(PlayerData pData)
  {
    this.playerData = pData;
    playerName.text = pData.name;
    hostIndicator.color = pData.isHost? Color.green : Color.blue;
  }
}