using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class UI_LobbyData : MonoBehaviour 
{
    // The input field to set the lobby name 
    [SerializeField] private TMP_InputField lobbyNameText;

    // The buttons to set the lobby to private or public
    [SerializeField] private Button privateLobbyButton;
    [SerializeField] private Button publicLobbyButton;
    [SerializeField] private bool isPrivate;
    
    // Slide to indicate max players 
    [SerializeField] private Slider maxPlayersSlider;
    [SerializeField] private TextMeshProUGUI maxPlayersText; // Update the text to show the give feedback on the max players

    // The map data
    [SerializeField] private TextMeshProUGUI mapDataText;
    [SerializeField] private string mapName;
    [SerializeField] private string mapAuthor;
    [SerializeField] private string mapId = "";

    // Menus
    [SerializeField] private GameObject lobbyMenu;

    // Create button and warning text
    [SerializeField] public Button createButton;
    [SerializeField] private Warning warning;

    public class LobbyData
    {
        public string lobbyName;
        public bool isPrivate;
        public int maxPlayers;
        public string mapName;
        public string mapAuthor;
        public string mapId;

        public void PrintData()
        {
          Debug.Log("Lobby Name: " + lobbyName);
          Debug.Log("Is Private: " + isPrivate);
          Debug.Log("Max Players: " + maxPlayers);
          Debug.Log("Map Name: " + mapName);
          Debug.Log("Map Author: " + mapAuthor);
          Debug.Log("Map Id: " + mapId);
        }
    }

    LobbyData lobbyData = null;

    public void Start()
    {
      // By default the lobby is public
      LobbyTypeSwitch(false);
      maxPlayersSlider.onValueChanged.AddListener(delegate { UpdateMaxPlayersText(); });
    }

    // Update the max players text
    public void UpdateMaxPlayersText()
    {
      maxPlayersText.text = "" + maxPlayersSlider.value;
    }

    // This is for testing purposes as it will be implemented in the future
    public void SetMockMapData()
    {
      UpdateMapData("The best map ever", "Xenos235", "235");
    }

    // Update the map data after selecting a map
    public void UpdateMapData(string mapName, string mapAuthor, string mapId)
    {
      this.mapName = mapName;
      this.mapAuthor = mapAuthor;
      this.mapId = mapId;

      mapDataText.text = "Map: " + mapName + "\n By: " + mapAuthor;
    }

    // Change the color of the button to indicate the lobby type
    public void LobbyTypeSwitch(bool isPrivate)
    {
      this.isPrivate = isPrivate;
      if (isPrivate)
      {
        privateLobbyButton.GetComponent<Image>().color = Color.green;
        publicLobbyButton.GetComponent<Image>().color = Color.white;
      }
      else
      {
        privateLobbyButton.GetComponent<Image>().color = Color.white;
        publicLobbyButton.GetComponent<Image>().color = Color.green;
      }
    }

    // Gather the lobby data and print it to check if it is correct
    public void CreateLobby()
    {
      lobbyData = new LobbyData();
      lobbyData.lobbyName = lobbyNameText.text;
      lobbyData.isPrivate = isPrivate;
      lobbyData.maxPlayers = (int)maxPlayersSlider.value;
      lobbyData.mapName = mapName;
      lobbyData.mapAuthor = mapAuthor;
      lobbyData.mapId = mapId;

      //lobbyData.PrintData();

      lobbyMenu.SetActive(true);
    }

    // Obtain the lobby data
    public LobbyData GetLobbyData()
    {
      return lobbyData;
    }

    // Update the max players text
    public void CheckIfDataIsFilled()
    {
      bool isAllDataFilled = false;
      if (string.IsNullOrWhiteSpace(lobbyNameText.text))
      {
        warning.ShowWarning("Don't forget to set the lobby name!", Warning.WarningType.Warning);
      }
      else if (string.IsNullOrWhiteSpace(mapId))
      {
        warning.ShowWarning("Don't forget to select a map!", Warning.WarningType.Warning);
      }
      else
      {
        isAllDataFilled = true;
      }

      createButton.interactable = isAllDataFilled;
    }

}