using UnityEngine;
using TMPro;
using UnityEngine.UI;

public class UI_LobbyView : MonoBehaviour
{
    [SerializeField] private TextMeshProUGUI lobbyNameText;
    [SerializeField] private TextMeshProUGUI lobbyIdText;
    [SerializeField] private TextMeshProUGUI lobbyPlayerCountText;
    [SerializeField] private GameObject lobbyView;
    [SerializeField] private Warning warning;
   private string lobbyId;

    public void SetLobbyName(string lobbyName)
    {
      lobbyNameText.text = lobbyName;
    }

    public void SetLobbyId(string lobbyId)
    {
      this.lobbyId = lobbyId;
      lobbyIdText.text = "Lobby ID:\n" + lobbyId;
    }

    public void SetLobbyPlayerCount(int playerCount, int maxPlayers)
    {
      lobbyPlayerCountText.text = "Players " 
                                  + playerCount.ToString() 
                                  + "/" + maxPlayers.ToString();
    }

    public void ShowLobbyView()
    {
      lobbyView.SetActive(true);
    }

    public void HideLobbyView()
    {
      lobbyView.SetActive(false);
    }

    public void CopyIdToClipboard()
    {
      GUIUtility.systemCopyBuffer = lobbyId;
      warning.ShowWarning("Lobby ID copied to clipboard!", Warning.WarningType.Positive);
    }
}