# Main Color Theme for Menus and UI

### 1. Primary UI Background (Main menu, settings, and in-game UI):
- **Soft Charcoal Grey**: `#3A3A3A`
  - <div style="width: 100px; height: 30px; background-color: #3A3A3A;"></div>
  - This provides a neutral, non-distracting background for the menus. It's dark enough to allow the vibrant UI elements to stand out, but not too dark to make the environment feel heavy. It’s modern, subtle, and keeps the focus on the content.

### 2. Main Buttons and Navigation Bar:
- **Vibrant Teal**: `#38B2A4`
  - <div style="width: 100px; height: 30px; background-color: #74e1b0;"></div>
  - This color is bright enough to catch the player’s attention and provide clear interactivity cues, but it's also cool and relaxing. It’s ideal for buttons, selections, and highlights, ensuring the UI feels approachable and user-friendly.

### 3. Secondary Buttons/Inactive Elements (Inactive options, subtle actions):
- **Muted Grey-Blue**: `#6C7B8B`
  - <div style="width: 100px; height: 30px; background-color: #6C7B8B;"></div>
  - This softer color can be used for less prominent menu elements, offering a sense of calm while distinguishing them from active buttons.

### 4. Hover/Active State for Buttons (When buttons are clicked, hovered over):
- **Lime Green**: `#A6E22E`
  - <div style="width: 100px; height: 30px; background-color: #A6E22E;"></div>
  - A bright green accent when hovering or selecting, creating immediate, clear feedback for player interactions.

### 5. Text (Menu Options, Navigation Labels):
- **Soft White**: `#F5F5F5`
  - <div style="width: 100px; height: 30px; background-color: #F5F5F5;"></div>
  - Clean, easy-to-read white text that contrasts well with the dark background and provides clarity without being too stark.

### 6. Highlights or Selected Item Indicator (Focused/Selected elements):
- **Golden Yellow**: `#F9E34F`
  - <div style="width: 100px; height: 30px; background-color: #F9E34F;"></div>
  - For highlighting selected items or actions, this yellow provides an energetic and positive contrast to the muted menu background, reinforcing success and direction.

---

## Accent Color for Subtle Effects:
These colors can be used for dynamic UI elements, transitions, and subtle effects to enhance the overall experience:

### 7. UI Hover Effects / Animations (Button interactions, transition states):
- **Light Aqua Glow**: `#A8F8F1`
  - <div style="width: 100px; height: 30px; background-color: #A8F8F1;"></div>
  - Soft glowing effects or subtle animations will use this light aqua color, providing a gentle contrast against the background while adding visual depth to the menus.

### 8. Icons or Small UI Elements (Icons for settings, sound, etc.):
- **Warm Beige**: `#D9B89A`
  - <div style="width: 100px; height: 30px; background-color: #D9B89A;"></div>
  - A neutral yet warm tone for icons or small UI elements that complements the overall theme and adds variety without overwhelming the player’s visual field.

### 9. Main Menu Background (For minimal distraction but vibrant focus):
- **Light Sky Blue**: `#A7D8F1` (same as the in-game background)
  - <div style="width: 100px; height: 30px; background-color: #A7D8F1;"></div>
  - To keep consistency, a subtle variation of this light sky blue can be used in the background for the menus, helping tie the UI to the game world. This makes the transition between the game and menus seamless, while still maintaining a soft and inviting tone.
