﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.EventSystems;
using TMPro;
// TODO this script needs refactoring, it is a bit messy
public class FixedJoystick : Joystick, IDragHandler
{
    private PlayerController playerController;
    public Image handleImage;
    private bool cancel = false;
    private float shootPower;
    private Vector2 eventPosition;
    [SerializeField] private float shootRange = 2.7f;
    [SerializeField] private float pickUpRange = 0.3f;
    public TextMeshProUGUI shootPowerIndicator; // The power the ball will be shooted
    public GameObject shootPowerIndicatorObject; // The power the ball will be shooted
    public int shootPowerMax = 65; // The max power the ball can be shooted
    private bool isCancelling = false;
    private void Awake()
    {
        // Find the player controller so we can shoot the balls
        playerController = GameObject.Find("Player").GetComponent<PlayerController>();
    }

    // Check if the shoot will be cancelled
    private void CheckValidShoot()
    {
        float remappedMagnitude = Mathf.Clamp01((inputMagnitude - cancelDistance) / (1.0f - cancelDistance)); // Remap to range [0, 1]
        GetShootPower();
        isCancelling = inputMagnitude <= cancelDistance;
        playerController.SetAimerVisible(!isCancelling);
        playerController.SetAimerDirection(Direction);
        playerController.SetAimerSize(remappedMagnitude);

        shootPowerIndicatorObject.SetActive(!isCancelling);

        SetPowerValue(shootPower);
    }

    // Detect if the joystick is being dragged
    public override void OnPointerDown(UnityEngine.EventSystems.PointerEventData eventData)
    {
        if (playerController.IsThrowable() == false) return;
        handleRange = shootRange;
        handleImage.color = Color.white;
        base.OnPointerDown(eventData);
        playerController.SetAimerState(true);
        CheckValidShoot();
        // Call it again to update the aimer direction
        base.OnPointerDown(eventData);
        CheckValidShoot();
    }

    

    // Detect if the joystick is being dragged
    public new void OnDrag(PointerEventData eventData)
    {   
        if (playerController.IsThrowable() == false) return;
        handleRange = shootRange;
        //TODO manage follow / explore mode better
        base.OnDrag(eventData);
        CheckValidShoot();
    }

    // Detect if the joystick is released    
    public override void OnPointerUp(UnityEngine.EventSystems.PointerEventData eventData)
    {
        if (playerController.IsThrowable() == false) return;

        handleRange = pickUpRange;
        
        GetShootPower();

        playerController.SetAimerState(false);
        if (cancel) // If the shoot is cancelled, don't shoot
        {
            handleImage.color = Color.white;
            cancel = false;
            playerController.SetAimerVisible(false);
            base.OnPointerUp(eventData);
            shootPowerIndicatorObject.SetActive(false);
            return;
        }
        playerController.ShootBall(Direction, shootPower);
        shootPowerIndicatorObject.SetActive(false);

        //base.OnPointerUp(eventData);
    }

    public void GetShootPower()
    {
        // Apply min max so we have the range [0, 1]
        float remappedMagnitude = Mathf.Clamp01((inputMagnitude - cancelDistance) / (1.0f - cancelDistance)); // Remap to range [0, 1]

        // Calculate the shoot power based on the remapped magnitude
        shootPower = remappedMagnitude * (shootPowerMax - 5) + 5; // This will map it to the range [5, shootPowerMax]

        //Debug.Log("Remapped magnitude: " + remappedMagnitude);
        //Debug.Log("Shoot power: " + shootPower);
    }

    public void SetPowerValue(float value)
    {
        // Calculate the percentage (1% to 100%)
        // Map the value (5 to 65) to 0% to 100%
        float powerPercentil = Mathf.InverseLerp(5, shootPowerMax, value); // InverseLerp maps the value to a percentage in the range [0, 1]
        
        // Convert to 1% to 100%
        int displayPercent = Mathf.RoundToInt(powerPercentil * 100); 

        // Display power percent (1% to 100%)
        shootPowerIndicator.text = Mathf.Clamp(displayPercent, 1, 100).ToString() + " %"; // Ensure it's at least 1%

    }
}