﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.EventSystems;
public class FixedJoystickLite : Joystick, IDragHandler
{
    private PlayerControllerLite playerController;
    public Image handleImage;
    private bool cancel = false;
    private float shootPower;
    private Vector2 eventPosition;
    [SerializeField] private float shootRange = 1.3f;
    [SerializeField] private float pickUpRange = 0.3f;
    private void Awake()
    {
        // Find the player controller so we can shoot the balls
        playerController = GameObject.Find("Player").GetComponent<PlayerControllerLite>();
    }

    // Check if the shoot will be cancelled
    private void CheckValidShoot()
    {
        float remappedMagnitude = Mathf.Clamp01((inputMagnitude - cancelDistance) / (1.0f - cancelDistance)); // Remap to range [0, 1]

        cancel = inputMagnitude <= cancelDistance;
        playerController.SetAimerVisible(!cancel);
        playerController.SetAimerDirection(Direction);
        playerController.SetAimerSize(remappedMagnitude);
    }

    // Detect if the joystick is being dragged
    public override void OnPointerDown(UnityEngine.EventSystems.PointerEventData eventData)
    {
        if (playerController.IsThrowable() == false) return;
        handleRange = shootRange;
        handleImage.color = Color.white;
        base.OnPointerDown(eventData);
        playerController.SetAimerState(true);
        CheckValidShoot();
        // Call it again to update the aimer direction
        base.OnPointerDown(eventData);
        CheckValidShoot();
    }

    

    // Detect if the joystick is being dragged
    public new void OnDrag(PointerEventData eventData)
    {   
        if (playerController.IsThrowable() == false) return;
        handleRange = shootRange;
        //TODO manage follow / explore mode better
        base.OnDrag(eventData);
        CheckValidShoot();
    }

    // Detect if the joystick is released    
    public override void OnPointerUp(UnityEngine.EventSystems.PointerEventData eventData)
    {
        if (playerController.IsThrowable() == false) return;

        handleRange = pickUpRange;
        
        // Apply min max so we have the range [0, 1]
        float remappedMagnitude = Mathf.Clamp01((inputMagnitude - cancelDistance) / (1.0f - cancelDistance)); // Remap to range [0, 1]

        // Calculate the shoot power based on the remapped magnitude
        shootPower = remappedMagnitude * 50; // In the future, each "maskot" will have a different shoot power
        //Debug.Log("Remapped magnitude: " + remappedMagnitude);
        //Debug.Log("Shoot power: " + shootPower);

        playerController.SetAimerState(false);
        playerController.SetAimerVisible(false);
        if (cancel) // If the shoot is cancelled, don't shoot
        {
            handleImage.color = Color.white;
            cancel = false;
            base.OnPointerUp(eventData);
            return;
        }

        playerController.ShootBall(Direction, shootPower);
        base.OnPointerUp(eventData);
    }
}