"""Add last_acces to CoursesUsersLink, status to PracticesUsersLink and color to Course

Revision ID: 9522e346f287
Revises: c8b079953483
Create Date: 2025-05-10 03:32:25.505245

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel.sql.sqltypes
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '9522e346f287'
down_revision = 'c8b079953483'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    sa.Enum('DEFAULT', 'RED', 'GREEN', 'BLUE', 'LIME', 'ORANGE', 'PURPLE', 'PINK', 'CYAN', 'INDIGO', name='colorenum').create(op.get_bind())
    sa.Enum('NOT_SUBMITTED', 'SUBMITTED', 'CORRECTING', 'CORRECTED', 'REJECTED', name='statusenum').create(op.get_bind())
    op.add_column('course', sa.Column('color', postgresql.ENUM('DEFAULT', 'RED', 'GREEN', 'BLUE', 'LIME', 'ORANGE', 'PURPLE', 'PINK', 'CYAN', 'INDIGO', name='colorenum', create_type=False), server_default='DEFAULT', nullable=False))
    op.add_column('coursesuserslink', sa.Column('last_access', sa.DateTime(), nullable=True))
    op.add_column('practicesuserslink', sa.Column('status', postgresql.ENUM('NOT_SUBMITTED', 'SUBMITTED', 'CORRECTING', 'CORRECTED', 'REJECTED', name='statusenum', create_type=False), server_default='NOT_SUBMITTED', nullable=False))
    op.drop_column('practicesuserslink', 'corrected')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('practicesuserslink', sa.Column('corrected', sa.BOOLEAN(), autoincrement=False, nullable=False))
    op.drop_column('practicesuserslink', 'status')
    op.drop_column('coursesuserslink', 'last_access')
    op.drop_column('course', 'color')
    sa.Enum('NOT_SUBMITTED', 'SUBMITTED', 'CORRECTING', 'CORRECTED', 'REJECTED', name='statusenum').drop(op.get_bind())
    sa.Enum('DEFAULT', 'RED', 'GREEN', 'BLUE', 'LIME', 'ORANGE', 'PURPLE', 'PINK', 'CYAN', 'INDIGO', name='colorenum').drop(op.get_bind())
    # ### end Alembic commands ###
