"""initial migration

Revision ID: c8b079953483
Revises: 
Create Date: 2025-03-26 01:37:08.443781

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel.sql.sqltypes
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'c8b079953483'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('course',
    sa.Column('name', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('academic_year', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('description', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('id', sa.Uuid(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('user',
    sa.Column('niub', sqlmodel.sql.sqltypes.AutoString(length=12), nullable=False),
    sa.Column('email', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('name', sqlmodel.sql.sqltypes.AutoString(length=255), nullable=False),
    sa.Column('surnames', sqlmodel.sql.sqltypes.AutoString(length=255), nullable=False),
    sa.Column('is_student', sa.Boolean(), nullable=False),
    sa.Column('is_teacher', sa.Boolean(), nullable=False),
    sa.Column('is_admin', sa.Boolean(), nullable=False),
    sa.Column('hashed_password', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.PrimaryKeyConstraint('niub')
    )
    op.create_index(op.f('ix_user_email'), 'user', ['email'], unique=True)
    op.create_table('coursesuserslink',
    sa.Column('user_niub', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('course_id', sa.Uuid(), nullable=False),
    sa.ForeignKeyConstraint(['course_id'], ['course.id'], ),
    sa.ForeignKeyConstraint(['user_niub'], ['user.niub'], ),
    sa.PrimaryKeyConstraint('user_niub', 'course_id')
    )
    op.create_table('practice',
    sa.Column('course_id', sa.Uuid(), nullable=True),
    sa.Column('name', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('description', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('programming_language', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('due_date', sa.Date(), nullable=False),
    sa.Column('id', sa.Uuid(), nullable=False),
    sa.ForeignKeyConstraint(['course_id'], ['course.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('practicesuserslink',
    sa.Column('user_niub', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('practice_id', sa.Uuid(), nullable=False),
    sa.Column('corrected', sa.Boolean(), nullable=False),
    sa.Column('correction', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.ForeignKeyConstraint(['practice_id'], ['practice.id'], ),
    sa.ForeignKeyConstraint(['user_niub'], ['user.niub'], ),
    sa.PrimaryKeyConstraint('user_niub', 'practice_id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('practicesuserslink')
    op.drop_table('practice')
    op.drop_table('coursesuserslink')
    op.drop_index(op.f('ix_user_email'), table_name='user')
    op.drop_table('user')
    op.drop_table('course')
    # ### end Alembic commands ###
