"""Add submission_date and submission_file_name field to PracticesUsersLink and ProgrammingLanguageEnum and datetime to due_date on Practice

Revision ID: c94f826165fe
Revises: 9522e346f287
Create Date: 2025-05-10 16:25:38.211135

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel.sql.sqltypes


# revision identifiers, used by Alembic.
revision = 'c94f826165fe'
down_revision = '9522e346f287'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    sa.Enum('PYTHON', 'JAVA', 'C', 'C_PLUS_PLUS', 'JAVASCRIPT', 'TYPESCRIPT', 'KOTLIN', 'HTML', 'CSS', 'R', name='programminglanguageenum').create(op.get_bind())
    op.alter_column('practice', 'programming_language',
               existing_type=sa.VARCHAR(),
               type_=sa.Enum('PYTHON', 'JAVA', 'C', 'C_PLUS_PLUS', 'JAVASCRIPT', 'TYPESCRIPT', 'KOTLIN', 'HTML', 'CSS', 'R', name='programminglanguageenum'),
               existing_nullable=False,
               postgresql_using='programming_language::programminglanguageenum')
    op.alter_column('practice', 'due_date',
               existing_type=sa.DATE(),
               type_=sa.DateTime(),
               existing_nullable=False)
    op.add_column('practicesuserslink', sa.Column('submission_date', sa.DateTime(), nullable=True))
    op.add_column('practicesuserslink', sa.Column('submission_file_name', sqlmodel.sql.sqltypes.AutoString(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('practicesuserslink', 'submission_file_name')
    op.drop_column('practicesuserslink', 'submission_date')
    op.alter_column('practice', 'due_date',
               existing_type=sa.DateTime(),
               type_=sa.DATE(),
               existing_nullable=False)
    op.alter_column('practice', 'programming_language',
               existing_type=sa.Enum('PYTHON', 'JAVA', 'C', 'C_PLUS_PLUS', 'JAVASCRIPT', 'TYPESCRIPT', 'KOTLIN', 'HTML', 'CSS', 'R', name='programminglanguageenum'),
               type_=sa.VARCHAR(),
               existing_nullable=False)
    sa.Enum('PYTHON', 'JAVA', 'C', 'C_PLUS_PLUS', 'JAVASCRIPT', 'TYPESCRIPT', 'KOTLIN', 'HTML', 'CSS', 'R', name='programminglanguageenum').drop(op.get_bind())
    # ### end Alembic commands ###
