import { SVGProps } from "react";
import { ChipProps } from "@heroui/chip";
import { ArrowPathIcon, CheckCircleIcon, ClockIcon, ExclamationTriangleIcon, XCircleIcon } from "@heroicons/react/24/outline";

export type IconSvgProps = SVGProps<SVGSVGElement> & {
  size?: number;
};

export const practiceStatusOptions = [
  { name: "No entregada", uid: "not_submitted", value: 0, icon: XCircleIcon },
  { name: "Entregada", uid: "submitted", value: 1, icon: ArrowPathIcon },
  { name: "Corregint-se", uid: "correcting", value: 2, icon: ClockIcon },
  { name: "Corregida", uid: "corrected", value: 3, icon: CheckCircleIcon },
  { name: "Rebutjada", uid: "rejected", value: 3, icon: XCircleIcon },
];

export const practiceStatusColorMap: Record<string, ChipProps["color"]> = {
  not_submitted: "danger",
  submitted: "primary",
  correcting: "warning",
  corrected: "success",
  rejected: "danger",
};

export const practiceStatusIconColorMap: Record<string, string> = {
  not_submitted: "text-danger-500",
  submitted: "text-primary-500",
  correcting: "text-warning-500",
  corrected: "text-success-500",
  rejected: "text-danger-500"
};

export const practices = [
  {
    id: 1,
    name: "Introducció a JavaScript",
    course: "Web Bàsica",
    teacher: "Laura Soler",
    teacherEmail: "laura.soler@ub.edu",
    status: "submitted",
    due_date: "2025-10-10T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=1",
  },
  {
    id: 2,
    name: "Components en React",
    course: "Desenvolupament Frontend",
    teacher: "Marc Vidal",
    teacherEmail: "marc.vidal@ub.edu",
    status: "correcting",
    due_date: "2025-08-08T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=2",
  },
  {
    id: 3,
    name: "API REST amb Node.js",
    course: "Backend amb JavaScript",
    teacher: "Carla Rius",
    teacherEmail: "carla.rius@ub.edu",
    status: "corrected",
    due_date: "2025-12-30T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=3",
  },
  {
    id: 4,
    name: "Estil amb TailwindCSS",
    course: "Disseny Web",
    teacher: "Joan Serra",
    teacherEmail: "joan.serra@ub.edu",
    status: "rejected",
    due_date: "2025-05-09T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=4",
  },
  {
    id: 5,
    name: "CRUD amb Supabase",
    course: "Bases de dades modernes",
    teacher: "Núria Bosch",
    teacherEmail: "nuria.bosch@ub.edu",
    status: "submitted",
    due_date: "2025-05-12T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=5",
  },
  {
    id: 6,
    name: "Validació de formularis",
    course: "Web Bàsica",
    teacher: "Laura Soler",
    teacherEmail: "laura.soler@ub.edu",
    status: "correcting",
    due_date: "2025-05-0923:59:59",
    avatar: "https://i.pravatar.cc/150?u=6",
  },
  {
    id: 7,
    name: "Rutes dinàmiques en Next.js",
    course: "Desenvolupament Frontend",
    teacher: "Marc Vidal",
    teacherEmail: "marc.vidal@ub.edu",
    status: "not_submitted",
    due_date: "2025-05-07T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=7",
  },
  {
    id: 8,
    name: "Autenticació amb Supabase",
    course: "Backend amb JavaScript",
    teacher: "Carla Rius",
    teacherEmail: "carla.rius@ub.edu",
    status: "corrected",
    due_date: "2025-12-29T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=8",
  },
  {
    id: 9,
    name: "Introducció a CSS Grid",
    course: "Disseny Web",
    teacher: "Joan Serra",
    teacherEmail: "joan.serra@ub.edu",
    status: "rejected",
    due_date: "2025-09-04T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=9",
  },
  {
    id: 10,
    name: "Relacions en PostgreSQL",
    course: "Bases de dades modernes",
    teacher: "Núria Bosch",
    teacherEmail: "nuria.bosch@ub.edu",
    status: "submitted",
    due_date: "2025-05-11T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=10",
  },
  {
    id: 11,
    name: "Intro a HTML semàntic",
    course: "Web Bàsica",
    teacher: "Laura Soler",
    teacherEmail: "laura.soler@ub.edu",
    status: "corrected",
    due_date: "2025-05-05T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=11",
  },
  {
    id: 12,
    name: "Hooks personalitzats",
    course: "Desenvolupament Frontend",
    teacher: "Marc Vidal",
    teacherEmail: "marc.vidal@ub.edu",
    status: "correcting",
    due_date: "2025-05-10T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=12",
  },
  {
    id: 13,
    name: "Autenticació amb tokens",
    course: "Backend amb JavaScript",
    teacher: "Carla Rius",
    teacherEmail: "carla.rius@ub.edu",
    status: "not_submitted",
    due_date: "2025-05-01T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=13",
  },
  {
    id: 14,
    name: "Flexbox avançat",
    course: "Disseny Web",
    teacher: "Joan Serra",
    teacherEmail: "joan.serra@ub.edu",
    status: "corrected",
    due_date: "2025-05-06T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=14",
  },
  {
    id: 15,
    name: "Indexos i consultes eficients",
    course: "Bases de dades modernes",
    teacher: "Núria Bosch",
    teacherEmail: "nuria.bosch@ub.edu",
    status: "submitted",
    due_date: "2025-05-13T23:59:59",
    avatar: "https://i.pravatar.cc/150?u=15",
  },
];